<?php
/**
 * @author: Nexi Payments SpA
 * @copyright: © 2017, Nexi Payments SpA
 * @license: GNU General Public License v3.0
 */

class NexiXPayS2SModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    /**
     * @see FrontController::postProcess()
     */
    public function postProcess()
    {
        $this->display_column_left = false;

        $paymentGateway = $this->module->getConfiguration();
        
        $rfo = new NexiXPayResponse();

        $rfo->setMacKey($paymentGateway->nexi_mac);

        $rfo->setAlias(Tools::getValue('alias'));
        $rfo->setImporto(Tools::getValue('importo'));
        $rfo->setDivisa(Tools::getValue('divisa'));
        $rfo->setCodTrans(Tools::getValue('codTrans'));
        $rfo->setSessionId(Tools::getValue('session_id'));
        $rfo->setBrand(Tools::getValue('brand'));
        $rfo->setNome(Tools::getValue('nome'));
        $rfo->setCognome(Tools::getValue('cognome'));
        $rfo->setMail(Tools::getValue('mail'));
        $rfo->setMac(Tools::getValue('mac'));
        $rfo->setEsito(Tools::getValue('esito'));
        $rfo->setData(Tools::getValue('data'));
        $rfo->setOrario(Tools::getValue('orario'));
        $rfo->setCodAut(Tools::getValue('codAut'));
        $rfo->setPan(Tools::getValue('pan'));
        $rfo->setScadenzaPan(Tools::getValue('scadenza_pan'));
        $rfo->setRegione(Tools::getValue('regione'));
        $rfo->setNazionalita(Tools::getValue('nazionalita'));
        $rfo->setMessaggio(Tools::getValue('messaggio'));
        $rfo->setHash(Tools::getValue('hash'));
        $rfo->setCheck(Tools::getValue('check'));
        $rfo->setDescrizione(Tools::getValue('descrizione'));
        $rfo->setLanguageId(Tools::getValue('languageId'));

        $rfo->calculateMac();

        if ($rfo->responseVerified() && Tools::strtolower($rfo->getEsito()) == 'ok') {
            $arr_exploded = explode('_', $rfo->getCodTrans());

            if (count($arr_exploded) > 1) {
                $id_cart = $arr_exploded[1];
                $cart = new Cart($id_cart);
                $this->context->cart = $cart;

                if (Validate::isLoadedObject($this->context->cart) && $this->context->cart->OrderExists() == true) {
                    header('500 Internal Server Error', true, 500);
                    exit;
                }

                if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 || $cart->id_address_invoice == 0 || !$this->module->active) {
                    header('500 Internal Server Error', true, 500);
                    exit;
                }

                $customer = new Customer($cart->id_customer);
                if (!Validate::isLoadedObject($customer)) {
                    header('500 Internal Server Error', true, 500);
                    exit;
                }

                $currency = $this->context->currency;
                $extraVars = array(
                    'transaction_id' => $rfo->getCodTrans(),
                );

                //$total = $cart->getOrderTotal(true, Cart::BOTH);
                $total = $rfo->getImporto()/100;
                $this->module->validateOrder(
                    $cart->id,
                    Configuration::get('PS_OS_PAYMENT'),
                    $total,
                    $this->module->displayName,
                    null,
                    $extraVars,
                    (int) $currency->id,
                    false,
                    $customer->secure_key
                );
            } else {
                header('500 Internal Server Error', true, 500);
            }
        } else {
            header('500 Internal Server Error', true, 500);
        }
        exit;
    }
}
